/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analyzer.issue;

import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonarsource.sonarlint.core.analyzer.issue.DefaultClientIssue;

public class DefaultFilterableIssue
implements FilterableIssue {
    private final DefaultClientIssue rawIssue;
    private final Project project;
    private final String componentKey;

    public DefaultFilterableIssue(Project project, DefaultClientIssue rawIssue, String componentKey) {
        this.project = project;
        this.rawIssue = rawIssue;
        this.componentKey = componentKey;
    }

    @Override
    public String componentKey() {
        return this.componentKey;
    }

    @Override
    public RuleKey ruleKey() {
        return RuleKey.parse(this.rawIssue.getRuleKey());
    }

    @Override
    public String severity() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public String message() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public Integer line() {
        return this.rawIssue.getStartLine();
    }

    @Override
    public Double effortToFix() {
        throw DefaultFilterableIssue.unsupported();
    }

    @Override
    public Date creationDate() {
        return this.project.getAnalysisDate();
    }

    @Override
    public String projectKey() {
        return this.project.getEffectiveKey();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not available for issues filters");
    }
}

